#ifndef __Clong__
#define __Clong__

//	===========================================================================

#include "CString.hpp"

//	===========================================================================

using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Basics
	{
		/**
		 * @class CLong CLong.hpp
		 * @brief Wrapper around built in type long
		 *
		 * Provides CCountedObject functionality around built in 'long' type
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CLong.hpp,v 1.3 2007/02/08 21:06:44 paul Exp $
		 */
		class CLong : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param value The value to store
			 */
			CLong(const long value = 0);

			/**
			 * Destruction
			 */
			virtual ~CLong();

//	===========================================================================

			/**
			 * Assignment operator
			 * @param value The value to store
			 * @retval CLong& A reference to this
			 */
			CLong &operator = (const CLong &value);

			/**
			 * Assignment operator
			 * @param value The value to store
			 * @retval CLong& A reference to this
			 */
			CLong &operator = (const long value);

			/**
			 * Equality operator
			 * @param value The value to compare to
			 * @retval bool True if values are equal, false otherwise
			 */
			bool operator == (const CLong &value);

			/**
			 * Equality operator
			 * @param value The value to compare to
			 * @retval bool True if values are equal, false otherwise
			 */
			bool operator == (const long value);

			/**
			 * InEquality operator
			 * @param value The value to compare to
			 * @retval bool True if values are inequal, false otherwise
			 */
			bool operator != (const CLong &value);

			/**
			 * InEquality operator
			 * @param value The value to compare to
			 * @retval bool True if values are inequal, false otherwise
			 */
			bool operator != (const long value);

			/**
			 * Addition operator
			 * @param value The value to add to this
			 * @retval CLong& A reference to this
			 */
			CLong &operator + (const CLong &value);

			/**
			 * Addition operator
			 * @param value The value to add to this
			 * @retval CLong& A reference to this
			 */
			CLong &operator + (const long value);

			/**
			 * Subtraction operator
			 * @param value The value to subtract from this
			 * @retval CLong& A reference to this
			 */
			CLong &operator - (const CLong &value);

			/**
			 * Subtraction operator
			 * @param value The value to subtract from this
			 * @retval CLong& A reference to this
			 */
			CLong &operator - (const long value);

			/**
			 * Multiplication operator
			 * @param value The value to multiply with this
			 * @retval CLong& A reference to this
			 */
			CLong &operator * (const CLong &value);

			/**
			 * Multiplication operator
			 * @param value The value to multiply with this
			 * @retval CLong& A reference to this
			 */
			CLong &operator * (const long value);

			/**
			 * Division operator
			 * @param value The value to divide with this
			 * @retval CLong& A reference to this
			 */
			CLong &operator / (const CLong &value);

			/**
			 * Division operator
			 * @param value The value to divide with this
			 * @retval CLong& A reference to this
			 */
			CLong &operator / (const long value);

			/**
			 * Plus equals operator
			 * @param value The value to add to this
			 * @retval CLong& A reference to this
			 */
			CLong &operator += (const CLong &value);

			/**
			 * Plus equals operator
			 * @param value The value to add to this
			 * @retval CLong& A reference to this
			 */
			CLong &operator += (const long value);

			/**
			 * Neg equals operator
			 * @param value The value to subtract from this
			 * @retval CLong& A reference to this
			 */
			CLong &operator -= (const CLong &value);

			/**
			 * Neg equals operator
			 * @param value The value to subtract from this
			 * @retval CLong& A reference to this
			 */
			CLong &operator -= (const long value);

			/**
			 * Not operator
			 * @retval bool True if value == 0, false otherwise
			 */
			bool operator ! ();

//	===========================================================================

			/**
			 * Set the value
			 * @param value The value to store
			 */
			void setValue(const CLong &value);

			/**
			 * Set the value
			 * @param value The value to store
			 */
			void setValue(const long value);

			/**
			 * Get the value
			 * @retval long The value stored
			 */
			long getValue() const;

			/**
			 * Get as a string
			 * @param preceedingZeros The level of precision in leading zeros
			 * @retval CString The long as a string (up to you to delete the CString returned)
			 */
			CString getValueAsString(const long preceedingZeros = 2) const;

//	===========================================================================

			/**
			 * Get a description of the object
			 * @param string On return is filled with the description
			 * @param size The size of the stirng
			 */
			virtual void getObjectDescription(char *string, const long size) const;

//	===========================================================================

		protected:

//	===========================================================================

			long m_value;			/**< The value being stored */

		};
	}
}
#endif	// End of CLong.hpp